/*
 * Decompiled with CFR 0.152.
 */
package org2.eclipse.php.internal.debug.core.xdebug.dbgp.protocol;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.DBGpLogger;
import org2.eclipse.php.internal.debug.core.xdebug.dbgp.protocol.DBGpResponse;

public class DBGpUtils {
    private static Map encoded = Collections.synchronizedMap(new HashMap());

    public static String getFileURIString(String fileName) {
        if (encoded.containsKey(fileName)) {
            return (String)encoded.get(fileName);
        }
        String fileURIStr = "";
        if (fileName == null || fileName.length() == 0) {
            return fileURIStr;
        }
        if (fileName.charAt(0) != '/') {
            fileName = "/" + fileName;
        }
        try {
            URI uri = new URI("file", "", fileName, null, null);
            fileURIStr = uri.toASCIIString();
            encoded.put(fileName, fileURIStr);
        }
        catch (URISyntaxException e) {
            DBGpLogger.logException("URISyntaxException - 1", null, e);
        }
        return fileURIStr;
    }

    public static String getFilenameFromURIString(String fileURIStr) {
        String filePath = "";
        try {
            URI uri = new URI(fileURIStr);
            filePath = uri.getPath();
            if (filePath != null && filePath.length() > 2 && filePath.charAt(2) == ':') {
                filePath = filePath.substring(1);
            }
        }
        catch (URISyntaxException e) {
            DBGpLogger.logException("URISyntaxException - 2", null, e);
        }
        return filePath;
    }

    public static boolean isGoodDBGpResponse(Object caller, DBGpResponse resp) {
        if (resp == null) {
            return false;
        }
        if (resp.getType() == 2 || resp.getType() == 3) {
            if (resp.getErrorCode() == 0 || resp.getErrorCode() == 300) {
                return true;
            }
            DBGpLogger.logError("DBGp Response Error: " + resp.getCommand() + ":=" + resp.getErrorCode() + " msg:" + resp.getErrorMessage(), caller, null);
        } else {
            DBGpLogger.logError("Unexpected XML or parser failure: " + resp.getRawXML(), caller, null);
        }
        return false;
    }
}

